#include <stdio.h>
#include "LPC13xx.h"                        // LPC13xx definitions 

#define LED2 (1<<8)                         // P0.8 LED2
#define LED3 (1<<9)                         // P0.9 LED3

unsigned int systick_stevec;                // števec tikov
//void setup_SysTick(void);

void SysTick_Handler (void){                // prekinitvena rutina za SysTick register
  systick_stevec++;                         // ko pride do prekinitve se poveča števec
}

void setup_SysTick(void){
//  SysTick->LOAD = 0x000AFC7F;             // Reload vrednost za 10ms pri 72MHz in delilniku 1.
  SysTick->LOAD = 0x0001193F;               // Reload vrednost za 1ms pri 72MHz in delilniku 1.
  SysTick->CTRL = 0x00000007;               // Omogoči systick, Omogoči tickint, clksource=core
} 

void Delay_ms (unsigned int cas_ms) {
unsigned int stevilo_systikov;
stevilo_systikov = systick_stevec;
while (( systick_stevec - stevilo_systikov) < cas_ms);  // V zanki dokler ne prešteje do cas_ms
}

int main (void) {	                          // Main Program    
setup_SysTick();
LPC_GPIO0->DIR |= LED2 | LED3;              // |= (ALI) Vpišemo 1 v 8 bit registra DIR (LED=P0.8)  
                                            // Nastavitev smeri PortaP0(GPIO0) P0=izhod				 
	while (1) {		                            // Loop forever
    LPC_GPIO0->DATA |= LED2;		            // |= (OR)  Vpiše 1 v 8  bit  registra DATA GPIO0.8  ugasne LED2
    Delay_ms (100);                         // Pove ime funkcije
    LPC_GPIO0->DATA &= ~LED2;               // vpiše 0 v 8  bit  registra DATA GPIO0.8  prizge LED2
    Delay_ms (100);
   }
}
