#include <stdio.h>
#include "LPC13xx.h"             // LPC13xx definitions
#include "serial.h"              // preprosta knjižnica za serijsko komunikacijo

#define LED2 (1<<8)              // P0.8  
#define LED3 (1<<9)              // P0.9
#define TIPKA (1<<1)             // Tipka INT je vezana na P0.1

int main (void) {                // Main Program 


int i;                           // spremenljivka i je tipa int
int ch;                          // spremenljivka ch je tipa int
LPC_GPIO0->DIR |= LED2;          // |= (ALI) Vpišemo 1 v 8 bit  registra DIR GPIO0.8,  P0.8=izhod  LED2
LPC_GPIO0->DIR |= LED3;          // |= (ALI) Vpišemo 1 v 9 bit  registra DIR GPIO0.9,  P0.9=izhod  LED3
 SER_init();                     // Inicializacija serijskega porta
	while (1) {                    // Neskončna zanka

	if (!(LPC_GPIO0->DATA & TIPKA))// Če je pritisnjena tipka se izvede naslednja vrstica
	{
  sendchar ('c');
	}
  if (chkkey())                  // če je prispel znak 
	{
  ch=getkey();                    
		if (ch=='c')                 // ali je prispeli znak c?
      {
	    	LPC_GPIO0->DATA ^=  LED2 | LED3;  // ^= (XOR)  Spremenimo če je bila prej 1 v 0 in obratno diodi LED2 in LED3
	    	for (i=0;i<1000000;i++);
  		}
	}
}
}
