#include <stdio.h>
#include "LPC13xx.h"                        // LPC13xx definitions 

#define LED2 (1<<8)                         // P0.8 LED2
#define LED3 (1<<9)                         // P0.9 LED3

int main (void) {	                          // Main Program    

LPC_GPIO0->DIR |= LED2 | LED3;              // |= (ALI) Vpišemo 1 v 8 bit registra DIR (LED=P0.8)  
     							                          // Nastavitev smeri PortaP0(GPIO0) P0=izhod				 
LPC_SYSCON->SYSAHBCLKCTRL |= (1<<7);        // vključi uro za CT16B0 register
LPC_SYSCON->SYSAHBCLKCTRL |= ((1UL <<  6)|  // vključi uro za GPIO
                              (1UL << 16)); // vključi uro za IOCON
LPC_IOCON->PIO0_9 |= 0x02;                  // 0000 0010 - PIO0_9 je priključen na CT16B0_MAT1 register
LPC_IOCON->PIO0_8 |= 0x02;                  // 0000 0010 - PIO0_8 je priključen na CT16B0_MAT0 register

LPC_TMR16B0->MCR  |= (1 << 10);             // 0000 0100 0000 0000 MR3R=1 - TC resetiran ko TC doseže vrednost MR3
LPC_TMR16B0->MR0  = 21598;                  // duty cycle 21598=75%, 7200=25% pri frekvenci 2,5KHz za PIO0_8 LED2
LPC_TMR16B0->MR1  = 7200;                   // duty cycle 14399=50%, 7200=25% pri frekvenci 2,5KHz za PIO0_9 LED3
LPC_TMR16B0->MR3  = 28798;                  // frekvenca 28798=2,5KHz, 14399=5KHz
LPC_TMR16B0->PWMC |= (1<<0);                // vključi PWM za CT16Bn MAT0  PIO0_8
LPC_TMR16B0->PWMC |= (1<<1);                // vključi PWM za CT16Bn MAT1  PIO0_9
LPC_TMR16B0->TCR  = 1;                      // TC + PC enabled

	while (1) {		                            // Loop forever
		

		}
	}
