#ifndef Temp_Pin
   #define Temp_Pin PIN_A0
   #define Temp_Bit (int1)(bit_test(input_a(),0));
#endif

int Senzor_Prisoten,Delcek_Stopinje,Izmerjena_Temperatura;
int Negativna_Temperatura;
int DS1820Data[9]={0,0,0,0,0,0,0,0,0};
int IzbranSenzor=0; // 0 - samo 1, 1 - senzor 1, 2 - senzor 2
int koda[8]={0,0,0,0,0,0};
int TipSenzorja=0;

void DolociKodo(int param[], int senzor)
{
   int temp;

   for (temp=0;temp<8;temp++)
   {
      koda[temp]=param[temp];
   }
   IzbranSenzor = senzor;
}

//**************************************************************
//    Inicializacija senzorja
//**************************************************************
void init1820()
{
   int vrednost=0;
                           // Zanemo tako, da postavimo
   output_high(Temp_Pin);
   delay_us(500);
   output_low(Temp_Pin);       // pin na low za ve kot 480 us
   delay_us(500);
   output_high(Temp_Pin);
                           // Sprostimo pin > input
   //vrednost=input_b();
   output_float(Temp_Pin);

   delay_us(100);          // Po 100us preberemo, e je
   vrednost=Temp_Bit; //   input_a();     // senzor odgovoril

   if (bit_test(vrednost,0))
   {
      // Napaka, senzor se ni "oglasil"
      Senzor_Prisoten =0;
   } else
   {
      // Vse v redu, nadaljujemo...
      Senzor_Prisoten=1;
   };

   delay_us(500);
}

//**************************************************************
//    Poiljanje podatkov senzorju
//**************************************************************

void write_0()
{
   output_low(Temp_Pin);
   delay_us(70);
   output_high(Temp_Pin);            // Spet na high
}

void write_1()
{
   output_low(Temp_Pin);
   delay_us(1);
   output_high(Temp_Pin);            // Spet na high
   delay_us(60);                 // za 50us
}

void send_to_ds1820(int podatki)
{
   int i;

   for (i=0;i<8;i++)                // 1 byte je sestavljen iz 8 bitov
   {
      output_high(Temp_Pin);            // najprej postavimo pin na 1
      delay_us(5);
      if (bit_test(podatki,i))
      {                             // e je 1, potem med low in high <15 us
         write_1();
      } else
      {                             // e je 0, potem med low in high 60-120 us
         write_0();
      };
 //     set_tris_b(0xFF);             // Nato sprostimo pin > input
   }
}

//**************************************************************
//    Branje podatkov s senzorja
//**************************************************************

int read_bit()
{
   int vrednost;
   output_high(Temp_Pin);
   delay_us(5);
   output_low(Temp_Pin);             // Zanemo tako, da za kratek as postavimo
   delay_us(1);                  // pin na low
   output_high(Temp_Pin);
  // set_tris_b(0xFF);

//   vrednost=input_b();           // Ter ga sprostimo
   output_float(Temp_Pin);

   vrednost=Temp_Bit; //   input_a();

   return vrednost;
}

int read_from_ds1820()
{
   int i;
   int prebrano=0;
   int minus=0;

   for (i=0;i<8;i++)                  // Podatki so sestavljenih iz 8 bitov
   {
      if (bit_test(read_bit(),0))
      {
         bit_set(prebrano,i);
      } else
      {
         bit_clear(prebrano,i);
      }
      delay_us(60);
   }

   return prebrano;
}

void StartMatchROM()
{
   int temp;
   send_to_ds1820(0x55);

   //lcd_gotoxy(1,2+IzbranSenzor);

   for (temp=0; temp<8; temp++)
   {
      send_to_ds1820(koda[temp]);
      //printf(lcd_putc,"%X",koda[temp]);
   }
}

//**************************************************************
//    Branje temperature
//**************************************************************
void StartTempConversion()
{
   init1820();
   send_to_ds1820(0xCC);
   send_to_ds1820(0x44);
}

void ReadTemperature()
{
   int temperatura;
   int16 temp;
   float temp2;

   init1820();
   //send_to_ds1820(0xCC);
   if (IzbranSenzor==0)
   {
      send_to_ds1820(0xCC);
   } else
   {
      StartMatchROM();
   }
   send_to_ds1820(0xBE);

   if (TipSenzorja==0)  // Senzor DS18S20
   {

      // Preberemo vrednost termometra
      temperatura=read_from_ds1820();
      Negativna_Temperatura = bit_test(read_from_ds1820(),0);

      if (bit_test(temperatura,0))
      {
         Delcek_Stopinje=5;
      } else
      {
         Delcek_Stopinje=0;
      };
      temperatura = temperatura>>1;

      if (Negativna_Temperatura==1)
      {
         if (Delcek_Stopinje==5)
         {
            temperatura=128-temperatura;
         } else
         {
            temperatura=129-temperatura;
         }
      };

      Izmerjena_Temperatura=temperatura;
   } else            // Senzor DS18B20
   {
       temperatura=read_from_ds1820();
       temp=read_from_ds1820();

       temp=temp*256;
       temp=temp+temperatura;


       Negativna_Temperatura=temp>0x0FFF; // bit_test(temp,15);

       if (Negativna_Temperatura==1)
       {
         temp=temp-0xF000;
         temp=!temp+1;
       }

       temp2=(float)temp;

       temp2=temp2/16;

       Izmerjena_Temperatura=(int)temp2;
       Delcek_Stopinje=(int)((temp2-Izmerjena_Temperatura)*10);
   }
}

void PreberiSerijsko()
{
   int x;
   init1820();
   send_to_ds1820(0x33);

   for (x=0;x<8;x++)
   {
      DS1820Data[x]=read_from_ds1820();
   }
}

void PreberiScratchPad()
{
   int x;
   init1820();

   if (IzbranSenzor==0)
   {
      send_to_ds1820(0xCC);
   } else
   {
      StartMatchROM();
   }
   send_to_ds1820(0xBE);

   for (x=0;x<9;x++)
   {
      DS1820Data[x]=read_from_ds1820();
   }
}

void PreberiTocno()
{
   if (TipSenzorja==0)
   {
      float tocno;
      float razlika;
      int temperatura;
      PreberiScratchPad();

      tocno = Izmerjena_Temperatura;
      tocno = tocno - 0.25;
      razlika=DS1820Data[7]-DS1820Data[6];
      tocno = tocno+razlika/((float)(DS1820Data[7]));
      Izmerjena_Temperatura=(int)tocno;
      tocno = tocno *10;
      Delcek_Stopinje=((int16)tocno)%10;
   }
}
